function [VX_V VY_V] = velocityfield(it,ix,iy,Y_V,X_V,VX_V,VY_V,yf_V,xramp_V,ramp,height,vx_bg,R,dt)

            if Y_V(ix,iy) < yf_V(ix)
                VX_V(ix,iy) = 0;
                VY_V(ix,iy) = 0;
            else
                %domain 1
                if Y_V(ix,iy) <= -tan((pi-ramp)/2)*X_V(ix,iy) + xramp_V*tan((pi-ramp)/2)
                    VX_V(ix,iy) = vx_bg;
                    VY_V(ix,iy) = 0;
                else
                    
                %If stage 1 of fault bend fold (Fig. 11.3a)
                if it * dt * vx_bg * sin(ramp) < height
                    %If point is in domain 2
                    if Y_V(ix,iy) >= (sin(ramp)/(cos(ramp)-R)) * X_V(ix,iy) - (sin(ramp)/(cos(ramp)-R))*(xramp_V+height*cot(ramp)) + height
                        VX_V(ix,iy) = vx_bg * cos(ramp);
                        VY_V(ix,iy) = vx_bg * sin(ramp);
                    else
                    %If point is in domain 3
                    VX_V(ix,iy)= vx_bg * R;
                    VY_V(ix,iy)= 0;
                    end
                    
                    %If stage 2 of fault bend fold (Fig. 11.3b)
                    else
                        %If point is in domain 2
                        if Y_V(ix,iy) <= -tan((pi-ramp)/2)* X_V(ix,iy) + (xramp_V+height*cot(ramp))*tan((pi-ramp)/2) + height
                            VX_V(ix,iy) = vx_bg * cos(ramp);
                            VY_V(ix,iy) = vx_bg * sin(ramp);
                        else
                            %If point is in domain 3
                            VX_V(ix,iy)= vx_bg * R;
                            VY_V(ix,iy)= 0;
                        end
                    end
                end
            end
            
            
end


